<?php
/**
 * @package   Yoobox for YOOtheme Pro 0.0.3 build 1013.0701
 * @author    Yoobox https://www.yoobox.io
 * @copyright Copyright (C) Millians Solutions, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

/*
 * Plugin Name: Yoobox for YOOtheme Pro
 * Plugin URI: http://www.yoobox.io
 * Description: Out of the box solutions for YOOtheme Pro
 * Author: Yoobox
 * Author URI: https://www.yoobox.io
 * Version: 0.0.3
 */

defined('WPINC') or die();

define('YOOBOX_VERSION', '0.0.3');
define('YOOBOX_LEVEL', 'premium');

if (!class_exists('YooboxHelper')) {
    require_once __DIR__ . '/classes/Helper.php';
}

// installer hooks
add_filter('upgrader_source_selection', [YooboxHelper::class, 'preinstallThemeCheck'], 10, 2);

try {
    YooboxHelper::validatePlatform();
    YooboxHelper::validateChecksums();
} catch (RuntimeException $e) {
    YooboxHelper::adminNotice($e->getMessage());

    return;
}

register_activation_hook(__FILE__, function () {
    try {
        YooboxHelper::validateChecksums(true);
    } catch (RuntimeException $e) {
        YooboxHelper::adminNotice($e->getMessage());

        return;
    }

    YooboxHelper::clearCache();
});

// Plugin Update Checker
if (file_exists(__DIR__ . '/modules/vendor/yahnis-elsts/plugin-update-checker/plugin-update-checker.php')) {
    require_once __DIR__ . '/modules/vendor/yahnis-elsts/plugin-update-checker/plugin-update-checker.php';

    $updateChecker = YahnisElsts\PluginUpdateChecker\v5\PucFactory::buildUpdateChecker(
        'https://cdn.yoobox.io/releases/update/wordpress.json',
        __FILE__,
        'yoobox'
    );
}

require_once __DIR__ . '/load-modules.php';
