<?php
/**
 * @package   Yoobox for YOOtheme Pro 0.0.3 build 1013.0701
 * @author    Yoobox https://www.yoobox.io
 * @copyright Copyright (C) Millians Solutions, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace Yoobox\Listener;

use YOOtheme\Config;
use YOOtheme\Str;

class LoadVersion
{
    public Config $config;

    public function __construct(Config $config)
    {
        $this->config = $config;
    }

    public function handle($meta)
    {
        if (Str::contains($meta->name, ':yoobox')) {
            $version = $this->config->get('yoobox.version');
            $build = $this->config->get('yoobox.build');
            $meta = $meta->withAttribute('version', $version . ($build ? "-$build" : ''));
        }

        return $meta;
    }
}
