<?php
/**
 * @package   Yoobox for YOOtheme Pro 0.0.3 build 1013.0701
 * @author    Yoobox https://www.yoobox.io
 * @copyright Copyright (C) Millians Solutions, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace Yoobox\Api;

use function YOOtheme\app;
use YOOtheme\Config;

trait InteractsWithApi
{
    private ?YooboxApiInterface $api = null;

    public function getApiInstance(): ?YooboxApiInterface
    {
        if ($this->api) {
            return $this->api;
        }

        /** @var YooboxApiInterface $api */
        $api = app(YooboxApiInterface::class);

        // Configure API client
        $this->configureApiClient($api);

        return $this->api = $api;
    }

    /**
     * Configure the API client with authentication and origin information.
     */
    protected function configureApiClient(YooboxApiInterface $api): void
    {
        $config = app(Config::class);

        // Set API key if available
        $apiKey = $config->get('~theme.yoobox_api_token');
        if ($apiKey) {
            $api->withApiKey($apiKey);
        }

        // Set site origin for yoobox origin authentication
        $siteOrigin = $this->getSiteOrigin();
        if ($siteOrigin) {
            $api->withSiteOrigin($siteOrigin);
        }

        // Set plugin version
        $pluginVersion = $this->getPluginVersion();
        if ($pluginVersion) {
            $api->withPluginVersion($pluginVersion);
        }
    }

    /**
     * Get the current site's origin/domain.
     */
    protected function getSiteOrigin(): ?string
    {
        // This should be implemented differently for Joomla vs WordPress
        // For now, use a generic approach
        if (isset($_SERVER['HTTP_HOST'])) {
            return $_SERVER['HTTP_HOST'];
        }

        return null;
    }

    /**
     * Get the plugin version.
     */
    protected function getPluginVersion(): string
    {
        // This should return the actual plugin version
        // You might want to get this from a constant or config
        return defined('YOOBOX_VERSION') ? YOOBOX_VERSION : '0.0.1';
    }
}
