<?php
/**
 * @package   Yoobox for YOOtheme Pro 0.0.3 build 1013.0701
 * @author    Yoobox https://www.yoobox.io
 * @copyright Copyright (C) Millians Solutions, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

$class_map = array_merge(
    // Yoobox classes
    include __DIR__ . '/vendor/composer/autoload_classmap.php',
    // Third-party classes.
    include __DIR__ . '/vendor/vendor/composer/autoload_classmap.php'
);

spl_autoload_register(
    function ($class) use ($class_map) {
        if (isset($class_map[$class]) && file_exists($class_map[$class])) {
            require_once $class_map[$class];

            return true;
        }
    },
    true,
    true
);

// Third-party files.
$files = require __DIR__ . '/vendor/vendor/autoload_files.php';
foreach ($files as $file_identifier => $file) {
    if (file_exists($file)) {
        require_once $file;
    }
}

// Files
// require_once __DIR__ .'/core/functions.php';
