<?php
/**
 * @package   Yoobox for YOOtheme Pro 0.0.3 build 1013.0701
 * @author    Yoobox https://www.yoobox.io
 * @copyright Copyright (C) Millians Solutions, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

use function YOOtheme\app;
use YOOtheme\Path;
use YOOtheme\Application;

defined('WPINC') or die();

add_action('after_setup_theme', function () {
    if (!class_exists(Application::class, false)) {
        return;
    }

    include_once __DIR__ . '/modules/autoload.php';

    Path::setAlias('~yoobox', __DIR__);

    $modules = [
        'yoobox',
        'yoobox-api',
    ];

    app()->load('~yoobox/modules/{' . implode(',', $modules) . '}{,-wordpress}/bootstrap.php');
});
