<?php
/**
 * @package   Yoobox for YOOtheme Pro 0.0.3 build 1013.0701
 * @author    Yoobox https://www.yoobox.io
 * @copyright Copyright (C) Millians Solutions, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

defined('_JEXEC') or die();

use function YOOtheme\app;
use YOOtheme\Path;
use YOOtheme\Application;
use Joomla\CMS\Plugin\CMSPlugin;

if (!class_exists('plgSystemYooboxHelper')) {
    require_once __DIR__ . '/helper.php';
}

class plgSystemYoobox extends CMSPlugin
{
    public function onExtensionBeforeUpdate(string $type, ?SimpleXMLElement $manifest)
    {
        if ($manifest) {
            plgSystemYooboxHelper::preinstallThemeCheck($manifest);
        }
    }

    public function onExtensionBeforeInstall(string $method, string $type, ?SimpleXMLElement $manifest)
    {
        if ($manifest) {
            plgSystemYooboxHelper::preinstallThemeCheck($manifest);
        }
    }

    public function onAfterInitialise()
    {
        try {
            plgSystemYooboxHelper::validatePlatform();
            plgSystemYooboxHelper::validateChecksums();
        } catch (RuntimeException $e) {
            plgSystemYooboxHelper::adminNotice($e->getMessage());

            return;
        }

        if (!class_exists(Application::class, false)) {
            return;
        }

        include_once __DIR__ . '/modules/autoload.php';

        Path::setAlias('~yoobox', Path::resolveAlias('~/plugins/system/yoobox'));

        $modules = [
            'yoobox',
            'yoobox-api',
        ];

        app()->load('~yoobox/modules/{' . implode(',', $modules) . '}{,-joomla}/bootstrap.php');
    }
}
