<?php
/**
 * @package   Yoobox for YOOtheme Pro 0.0.3 build 1013.0701
 * @author    Yoobox https://www.yoobox.io
 * @copyright Copyright (C) Millians Solutions, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace Yoobox;

use YOOtheme\Http\Request;
use YOOtheme\Http\Response;

class YooboxController
{
    use Api\InteractsWithApi;

    public function getAssets(Request $request, Response $response)
    {
        try {
            /** @var Api\YooboxApiInterface $api */
            $api = $this->getApiInstance();

            $assets = $api->listAssets();

            return $response->withJson($assets, 200);
        } catch (\Throwable $e) {
            return $response->withJson($e->getMessage(), 400);
        }
    }

    public function loadAsset(Request $request, Response $response)
    {
        try {
            /** @var Api\YooboxApiInterface $api */
            $api = $this->getApiInstance();

            $alias = $request->getParam('alias');

            $asset = $api->loadAsset($alias);

            return $response->withJson($asset, 200);
        } catch (\Throwable $e) {
            return $response->withJson($e->getMessage(), 400);
        }
    }

    public function saveAsset(Request $request, Response $response)
    {
        try {
            /** @var Api\YooboxApiInterface $api */
            $api = $this->getApiInstance();

            $assetData = $request->getParsedBody();

            $asset = $api->saveAsset($assetData);

            return $response->withJson($asset, 200);
        } catch (\Throwable $e) {
            return $response->withJson($e->getMessage(), 400);
        }
    }
}
