<?php
/**
 * @package   Yoobox for YOOtheme Pro 0.0.3 build 1013.0701
 * @author    Yoobox https://www.yoobox.io
 * @copyright Copyright (C) Millians Solutions, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace Yoobox\Listener;

use YOOtheme\Config;
use YOOtheme\Metadata;
use YOOtheme\Path;
use YOOtheme\Url;

class LoadCustomizerData
{
    public Config $config;

    public function __construct(Config $config, public Metadata $metadata)
    {
        $this->config = $config;
    }

    public function handle(): void
    {
        $this->config->addFile('customizer', Path::get('../../config/customizer.json'));

        $values = [
            'base' => Url::to('~yoobox'),
            'version' => $this->config->get('yoobox.version'),
            'assetUrl' => 'https://yoobox.io/assets/{alias}',
        ];

        $this->metadata->set(
            'script:yoobox-data',
            sprintf(
                'window.yoobox ||= {}; yoobox = %s;',
                json_encode($values),
            ),
        );

        $this->metadata->set('script:yoobox-js', [
            'src' => '~yoobox/app/yoobox.min.js',
            'defer' => true,
        ]);

        $this->metadata->set('style:yoobox-css', [
            'href' => '~yoobox/app/yoobox.min.css',
            'defer' => true,
        ]);
    }
}
