<?php
/**
 * @package   Yoobox for YOOtheme Pro 0.0.3 build 1013.0701
 * @author    Yoobox https://www.yoobox.io
 * @copyright Copyright (C) Millians Solutions, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace Yoobox;

return [
    'config' => [
        'yoobox' => [
            'version' => '0.0.3',
            'build' => '1013.0701',
        ]
    ],

    'events' => [
        'customizer.init' => [
            Listener\LoadCustomizerData::class => ['@handle', 10]
        ],

        'metadata.load' => [
            Listener\LoadVersion::class => ['@handle', -10]
        ],
    ],

    'routes' => [
        ['post', 'yoobox/api/assets', YooboxController::class . '@getAssets'],
        ['post', 'yoobox/api/assets/load', YooboxController::class . '@loadAsset'],
        ['post', 'yoobox/api/assets/save', YooboxController::class . '@saveAsset'],
    ],

    'services' => [
        Api\YooboxApiInterface::class => Api\YooboxApi::class,
    ],
];
