<?php
/**
 * @package   Yoobox for YOOtheme Pro 0.0.3 build 1013.0701
 * @author    Yoobox https://www.yoobox.io
 * @copyright Copyright (C) Millians Solutions, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

defined('_JEXEC') or die();

use Joomla\CMS\Factory;
use Joomla\CMS\Filesystem\File;
use Joomla\CMS\Filesystem\Folder;
use Joomla\CMS\Installer\Installer;
use Joomla\CMS\Installer\InstallerHelper;

if (!class_exists('plgSystemYooboxHelper')) {
    require_once __DIR__ . '/helper.php';
}

class plgSystemYooboxInstallerScript
{
    public function preflight($type, $parent)
    {
        if (!in_array($type, ['install', 'update'])) {
            return;
        }

        try {
            plgSystemYooboxHelper::validatePlatform();
        } catch (RuntimeException $e) {
            plgSystemYooboxHelper::adminNotice($e->getMessage());

            return false;
        }

        // prevent downgrade
        if ($this->isPremiumInstalled() and !$this->isPremiumBeingInstalled($parent)) {
            plgSystemYooboxHelper::adminNotice(
                'Yoobox plugin downgrade has been prevented. Please uninstall Yoobox before trying to downgrade to the free version.'
            );

            return false;
        }

        $this->relocateIcons();

        // by deleting the update servers we keep them up to date as well as solving
        // the potential issue of free update server overtaking the premium one
        if ($type === 'update') {
            $this->deleteUpdateServers($parent);
        }

        // delete modules to avoid potential update and downgrade issues
        if (Folder::exists($path = JPATH_ROOT . '/plugins/system/yoobox/modules')) {
            Folder::delete($path);

            // delete checskum.pass to force validation
            if (File::exists($path . '/checksum.pass')) {
                File::delete($path . '/checksum.pass');
            }
        }
    }

    public function postflight($type, $parent)
    {
        if (!in_array($type, ['install', 'update'])) {
            return;
        }

        $this->installInstallerPackage($parent);

        if ($type === 'install') {
            $this->enableExtension();
        }

        plgSystemYooboxHelper::clearCache();

        return true;
    }

    private function relocateIcons()
    {
        $src = JPATH_ROOT . '/plugins/system/yoobox/modules/icons/icons';
        $dst = JPATH_ROOT . '/media/yoobox/icons';

        if (Folder::exists($src)) {
            Folder::copy($src, $dst, '', true);
            Folder::delete($src);
        }
    }

    protected function deleteUpdateServers($parent)
    {
        $db = Factory::getDBO();

        $ids = $db
            ->setQuery(
                'SELECT `update_site_id` FROM `#__update_sites_extensions`' .
                    " WHERE `extension_id` = (SELECT `extension_id` FROM `#__extensions` WHERE `type` = 'plugin' AND `folder` = 'system' AND `element` = 'yoobox')"
            )
            ->loadObjectList();

        foreach ($ids as $id) {
            $db->setQuery(
                "DELETE FROM `#__update_sites_extensions` WHERE `update_site_id` = $id->update_site_id"
            )->execute();

            $db->setQuery("DELETE FROM `#__update_sites` WHERE `update_site_id` = $id->update_site_id")->execute();
        }
    }

    protected function isPremiumBeingInstalled($parent)
    {
        $src = $parent->getParent()->getPath('source');

        return Folder::exists("$src/modules/pro");
    }

    protected function isPremiumInstalled()
    {
        return Folder::exists(JPATH_ROOT . '/plugins/system/yoobox/modules/pro');
    }

    // silent install of zoolanders installer
    private function installInstallerPackage($parent)
    {
        $src = $parent->getParent()->getPath('source');

        try {
            if (File::exists("$src/installer.zip")) {
                $package = InstallerHelper::unpack("$src/installer.zip")['dir'];

                $tmpInstaller = new Installer();
                $tmpInstaller->install($package);
            }
        } catch (Throwable $e) {
            return;
        }
    }

    private function enableExtension()
    {
        $db = Factory::getDbo();

        try {
            $query = $db
                ->getQuery(true)
                ->update('#__extensions')
                ->set($db->qn('enabled') . ' = ' . $db->q(1))
                ->where('type = ' . $db->quote('plugin'))
                ->where('folder = ' . $db->quote('system'))
                ->where('element = ' . $db->quote('yoobox'));

            $db->setQuery($query)->execute();
        } catch (Throwable $e) {
            return;
        }
    }
}
